;;  Programm:      ACM-LIBOZUPL.LSP
;;  Befehlsaufruf: ACM-LIBOZUPL
;;  Funktion:      Konvertiert Linien und Bogen in LW- oder 2D-Polylinien.
;;  Autor:         Gerhard Rampf
;;                 Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;                 Liebigstr. 3 A
;;                 86399 Bobingen
;;                 E-Mail: rampf@geracad.de
;;  Datum:         08.10.2022
;;  Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-libozupl ( / lbp032 lbp129 pbl001 pbl002 pbl003 pbl004 pbl006 pbl007 pbl010 pbl011 pbl012 pbl013 pbl014 pbl015 pbl016 pbl017 pbl018 pbl019 pbl020 pbl021 pbl022 pbl023)
    (defun pbl001 (lbp001 / lbp028 lbp029)
      (setq lbp001 (strcase (setq lbp028 lbp001)))
        (if (vl-position lbp001 (list "VONBLOCK" "VONLAYER"))
          (progn
            (if (= lbp001 "VONBLOCK")
              (setq lbp029 "_ByBlock")
              (setq lbp029 "_ByLayer")
            )
          )
          (setq lbp029 lbp028)
        )
      lbp029
    )
    (defun pbl002 ( / lbp030 lbp031)
      (setq lbp030 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= lbp030 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq lbp031 T)
            (setq lbp031 nil)
        )
        (if (not lbp031)
          (alert "\042acm-libozupl\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      lbp031
    )
    (defun pbl003 ( / lbp032 lbp033 lbp034 lbp035)
      (setq lbp032 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq lbp033 (vla-get-Layers lbp032))
        (vlax-for layer lbp033
          (if (not (vl-string-search "|" (setq lbp034 (vla-get-Name layer))))
            (setq lbp035 (cons lbp034 lbp035))
          )
        )
      (acad_strlsort lbp035)
    )
    (defun pbl004 ( / pbl005 lbp041 lbp042 lbp043 lbp040)
        (defun pbl005 (lbp002 lbp003 / lbp036 lbp037 lbp038 lbp039)
          (setq lbp036 (strlen lbp002))
          (setq lbp037 1)
            (while (<= lbp037 lbp036)
              (setq lbp038 (substr lbp002 lbp037 1))
                (if (/= lbp038 lbp003)
                  (progn
                    (setq lbp039 nil)
                    (setq lbp037 (1+ lbp037))
                  )
                )
                (if (= lbp038 lbp003)
                  (progn
                    (setq lbp039 lbp037)
                    (setq lbp037 (1+ lbp036))
                  )
                )
            )
          lbp039
        )
      (setq lbp040 '())
      (setq lbp041 (tblnext "LTYPE" T))
      (setq lbp042 (cdr (assoc 2 lbp041)))
        (if (not (pbl005 lbp042 "\174"))
          (setq lbp040 (cons lbp042 lbp040))
        )
      (setq lbp043 (tblnext "LTYPE"))
        (while lbp043
          (setq lbp042 (cdr (assoc 2 lbp043)))
            (if (not (pbl005 lbp042 "\174"))
              (setq lbp040 (cons lbp042 lbp040))
            )
          (setq lbp043 (tblnext "LTYPE"))
        )
        (if lbp040
          (setq lbp040 (acad_strlsort lbp040))
        )
      (cons "VonLayer" (cons "VonBlock" lbp040))
    )
    (defun pbl006 (lbp004 / lbp044 lbp045)
      (if
        (and
          (setq lbp044 (vl-filename-mktemp "acm121.dcl"))
          (setq lbp045 (open lbp044 "w"))
        )
          (progn
            (while lbp004
              (write-line (car lbp004) lbp045)
              (setq lbp004 (cdr lbp004))
            )
            (setq lbp045 (close lbp045))
            lbp044
          )
          nil
      )
    )
    (defun pbl007 (lbp005 lbp006 / pbl008 pbl009 lbp053 lbp054)
        (defun pbl008 (lbp007 lbp008 / lbp046 lbp047 lbp048 lbp049 lbp050 lbp051 lbp052)
          (setq lbp046 lbp007)
          (setq lbp047 lbp008)
            (repeat (length lbp046)
              (setq lbp048 (cons (strcase (car lbp046)) lbp048))
              (setq lbp046 (cdr lbp046))
            )
            (repeat (length lbp047)
              (setq lbp049 (cons (strcase (car lbp047)) lbp049))
              (setq lbp047 (cdr lbp047))
            )
          (setq lbp048 (reverse lbp048))
          (setq lbp049 (reverse lbp049))
            (repeat (length lbp048)
              (setq lbp050 (member (car lbp048) lbp049))
                (if lbp050
                  (progn
                    (setq lbp051 (- (length lbp049) (length lbp050)))
                    (setq lbp052 (cons (nth lbp051 lbp008) lbp052))
                  )
                )
              (setq lbp048 (cdr lbp048))
            )
          (reverse lbp052)
        )
        (defun pbl009 (lbp009 lbp010 / )
          (if (member lbp009 lbp010)
            (- (length lbp010) (length (member lbp009 lbp010)))
          )
        )
      (setq lbp053 lbp006)
        (while lbp053
          (setq lbp054 (cons (strcase (car lbp053)) lbp054))
          (setq lbp053 (cdr lbp053))
        )
        (if (member (strcase lbp005) lbp054)
          (list (car (pbl008 (list lbp005) lbp006)) (pbl009 (strcase lbp005) (reverse lbp054)))
          nil
        )
    )
    (defun pbl010 (lbp001 lbp011 / lbp058 lbp055 lbp056 lbp057)
      (setq lbp055 (strlen lbp001))
        (if (> lbp055 lbp011)
          (progn
            (setq lbp056 (substr lbp001 1 (/ (- lbp011 3) 2)))
            (setq lbp057 (substr lbp001 (- lbp055 (1- (/ (- lbp011 3) 2)))))
            (setq lbp058 (strcat lbp056 "\056\056\056" lbp057))
          )
        )
        (if lbp058
          lbp058
          lbp001
        )
    )
    (defun pbl011 (lbp012 lbp013 / lbp059 lbp060 lbp061 lbp062 lbp063 lbp070 lbp071 lbp072 lbp073 lbp074 lbp079 lbp080 lbp081 lbp082 lbp083 lbp084 lbp085 lbp086 lbp087 lbp088 lbp089 lbp090 lbp091 lbp092 lbp093)
      (setq lbp059
        (list
          "acm121"
          ":dialog{key=\042t_01\042;"
          ":spacer{height=0.20;}"
          ":popup_list{key=\042pl_00\042;label=\042&Einzubeziehende Objekttypen:\042;}"
          ":spacer{height=0.20;}"
          ":row{"
          ":text{key=\042t_00\042;label=\042Umwandeln in:\042;}"
          ":radio_button{key=\042rb_01\042;label=\042L&W-Polylinien\042;}"
          ":radio_button{key=\042rb_02\042;label=\042&2D-Polylinien\042;}}"
          ":spacer{height=0.20;}"
          ":boxed_column{label=\042Eigenschaften der Polylinien\042;"
          ":toggle{key=\042tg_01\042;label=\042Alle von Quellobjekten bernehmen\042;mnemonic=\042A\042;}"
          ":spacer{height=0.10;}"
          ":row{"
          ":spacer{width=1.80;}"
          ":column{"
          ":row{"
          ":column{"
          ":spacer{height=0.20;}"
          ":toggle{key=\042tg_02\042;label=\042Farbe:\042;mnemonic=\042F\042;}"
          ":spacer{height=0.00;}}"
          ":button{key=\042b_01\042;label=\042...\042;width=8.00;fixed_width=true;}"
          ":column{"
          ":spacer{height=0.10;}"
          ":image_button{key=\042ib_01\042;width=2.90;fixed_width=true;height=1.30;fixed_height=true;color=dialog_background;}"
          ":spacer{height=0.00;}}"
          ":text{key=\042t_02\042;width=30.20;fixed_width=true;}}"
          ":row{"
          ":column{"
          ":spacer{height=0.05;}"
          ":toggle{key=\042tg_03\042;label=\042Layer:\042;mnemonic=\042L\042;}}"
          ":popup_list{key=\042pl_01\042;label=\042\042;edit_width=31.70;fixed_width=true;}}"
          ":row{"
          ":column{"
          ":spacer{height=0.05;}"
          ":toggle{key=\042tg_04\042;label=\042Linientyp:\042;mnemonic=\042i\042;}}"
          ":popup_list{key=\042pl_02\042;label=\042\042;edit_width=31.70;fixed_width=true;}}"
          ":spacer{height=0.10;}}}}"
          ":spacer{height=0.20;}"
          ":toggle{key=\042tg_05\042;label=\042Q&uellobjekte erhalten\042;mnemonic=\042u\042;}"
          ":spacer{height=0.20;}"
          ":row{"
          ":spacer{width=6.50;}"
          ":button{key=\042b_02\042;label=\042OK\042;width=19.00;fixed_width=true;is_default=true;}"
          ":button{key=\042b_03\042;label=\042Abbrechen\042;width=19.00;fixed_width=true;is_cancel=true;}"
          ":spacer{width=6.50;}}"
          ":spacer{height=0.00;}}"
        )
      )
      (setq lbp060 lbp012)
      (setq lbp061 lbp013)
      (setq lbp062 (pbl006 lbp059))
      (setq lbp063 (load_dialog lbp062))
        (if (not (new_dialog "acm121" lbp063))
          (exit)
        )
      (vl-catch-all-apply 'vl-file-delete (list lbp062))
      (set_tile "t_01" "Einstellungen")
      (start_list "pl_01")
      (mapcar 'add_list lbp060)
      (end_list)
      (start_list "pl_02")
      (mapcar 'add_list lbp061)
      (end_list)
        (if (not (vl-position acm82022grlibozupl_01 '("0" "1" "2")))
          (setq acm82022grlibozupl_01 "2")
        )
        (if (not (vl-position acm82022grlibozupl_02 '("0" "1")))
          (setq acm82022grlibozupl_02 "0")
        )
        (if (not (= (type acm82022grlibozupl_03) 'STR))
          (setq acm82022grlibozupl_03 "0")
        )
        (if (not (= (type acm82022grlibozupl_04) 'STR))
          (setq acm82022grlibozupl_04 "0")
        )
        (if (not (pbl007 acm82022grlibozupl_04 lbp060))
          (setq acm82022grlibozupl_04 "0")
        )
      (set_tile "pl_01" (itoa (cadr (pbl007 acm82022grlibozupl_04 lbp060))))
        (if (not (= (type acm82022grlibozupl_05) 'STR))
          (setq acm82022grlibozupl_05 "VonLayer")
        )
        (if (not (pbl007 acm82022grlibozupl_05 lbp061))
          (setq acm82022grlibozupl_05 "VonLayer")
        )
      (set_tile "pl_02" (itoa (cadr (pbl007 acm82022grlibozupl_05 lbp061))))
        (if (not (= (type acm82022grlibozupl_06) 'LIST))
          (setq acm82022grlibozupl_06 '((62 . 256)))
        )
      (setq lbp070 acm82022grlibozupl_05)
      (setq lbp071 acm82022grlibozupl_06)
      (setq lbp072 acm82022grlibozupl_04)
      (setq lbp073 acm82022grlibozupl_01)
      (setq lbp074 acm82022grlibozupl_02)
        (if (not (= (type acm82022grlibozupl_07) 'INT))
          (setq acm82022grlibozupl_07 1)
        )
        (if (not (= (type acm82022grlibozupl_08) 'INT))
          (setq acm82022grlibozupl_08 0)
        )
        (if (not (= (type acm82022grlibozupl_09) 'INT))
          (setq acm82022grlibozupl_09 0)
        )
        (if (not (= (type acm82022grlibozupl_10) 'INT))
          (setq acm82022grlibozupl_10 0)
        )
      (setq lbp079 acm82022grlibozupl_07)
      (setq lbp080 acm82022grlibozupl_08)
      (setq lbp081 acm82022grlibozupl_09)
      (setq lbp082 acm82022grlibozupl_10)
        (if (= acm82022grlibozupl_02 "0")
          (set_tile "rb_01" "1")
          (set_tile "rb_02" "1")
        )
      (start_list "pl_00")
      (mapcar 'add_list (list "Linien" "Bogen" "Linien und Bogen"))
      (end_list)
      (set_tile "pl_00" acm82022grlibozupl_01)
      (set_tile "tg_01" (itoa acm82022grlibozupl_07))
      (set_tile "tg_02" (itoa acm82022grlibozupl_08))
      (set_tile "tg_03" (itoa acm82022grlibozupl_09))
      (set_tile "tg_04" (itoa acm82022grlibozupl_10))
      (set_tile "tg_05" acm82022grlibozupl_03)
        (if (> acm82022grlibozupl_07 0)
          (progn
            (mode_tile "tg_02" 1)
            (mode_tile "b_01" 1)
            (mode_tile "ib_01" 1)
            (mode_tile "t_02" 1)
            (mode_tile "tg_03" 1)
            (mode_tile "pl_01" 1)
            (mode_tile "tg_04" 1)
            (mode_tile "pl_02" 1)
          )
          (progn
            (if (< (atoi (get_tile "tg_02")) 1)
              (progn
                (mode_tile "b_01" 1)
                (mode_tile "ib_01" 1)
                (mode_tile "t_02" 1)
              )
            )
            (if (< (atoi (get_tile "tg_03")) 1)
              (mode_tile "pl_01" 1)
            )
            (if (< (atoi (get_tile "tg_04")) 1)
              (mode_tile "pl_02" 1)
            )
          )
        )
      (setq lbp083 (abs (cdr (assoc 62 acm82022grlibozupl_06))))
        (if
          (and
            (> lbp083 0)
            (< lbp083 256)
          )
            (progn
              (if (assoc 430 acm82022grlibozupl_06)
                (setq lbp084 (substr (cdr (assoc 430 acm82022grlibozupl_06)) (+ 2 (vl-string-search "$" (cdr (assoc 430 acm82022grlibozupl_06))))))
                (progn
                  (if (assoc 420 acm82022grlibozupl_06)
                    (progn
                      (setq lbp085 (cdr (assoc 420 acm82022grlibozupl_06)))
                      (setq lbp084 (strcat (itoa (lsh (fix lbp085) -16)) "," (itoa (lsh (lsh (fix lbp085) 16) -24)) "," (itoa (lsh (lsh (fix lbp085) 24) -24))))
                    )
                    (progn
                      (if (< lbp083 8)
                        (setq lbp084 (nth (1- lbp083) '("Rot" "Gelb" "Grn" "Cyan" "Blau" "Magenta" "Wei")))
                        (setq lbp084 (strcat "Farbe " (itoa lbp083)))
                      )
                    )
                  )
                )
              )
            )
        )
        (if (= lbp083 256)
          (progn
            (setq lbp084 "VonLayer")
            (setq lbp086 (nth (atoi (get_tile "pl_01")) lbp060))
            (setq lbp087 (entget (tblobjname "LAYER" lbp086)))
            (setq lbp083 (abs (cdr (assoc 62 lbp087))))
          )
        )
        (if (= lbp083 0)
          (progn
            (setq lbp084 "VonBlock")
            (setq lbp083 7)
          )
        )
      (set_tile "t_02" (pbl010 lbp084 33))
      (start_image "ib_01")
      (fill_image 0 0 (dimx_tile "ib_01") (dimy_tile "ib_01") lbp083)
      (end_image)
        (action_tile "pl_01" "(if (equal acm82022grlibozupl_06 '((62 . 256)))
          (progn
          (setq lbp088 (nth (atoi $value) lbp060))
          (setq lbp089 (entget (tblobjname \"LAYER\" lbp088)))
          (setq lbp090 (abs (cdr (assoc 62 lbp089))))
          (start_image \"ib_01\")
          (fill_image 0 0 (dimx_tile \"ib_01\") (dimy_tile \"ib_01\") lbp090)
          (end_image)))
          (setq acm82022grlibozupl_04 (nth (atoi $value) lbp060))"
        )
        (action_tile "pl_02" "(setq acm82022grlibozupl_05 (nth (atoi $value) lbp061))")
        (action_tile "b_01" "(setq lbp088 (nth (atoi (get_tile \"pl_01\")) lbp060))
          (setq lbp089 (entget (tblobjname \"LAYER\" lbp088)))
          (if (assoc 430 lbp089)
          (setq lbp091 (assoc 430 lbp089))
          (progn
          (if (assoc 420 lbp089)
          (setq lbp091 (assoc 420 lbp089))
          (setq lbp091 (cons 62 (abs (cdr (assoc 62 lbp089))))))))
          (if (setq lbp092 (acad_truecolordlg (last acm82022grlibozupl_06) T lbp091))
          (progn
          (setq acm82022grlibozupl_06 lbp092)
          (setq lbp083 (abs (cdr (assoc 62 lbp092))))
          (if (and
          (> lbp083 0)
          (< lbp083 256))
          (progn
          (if (assoc 430 lbp092)
          (setq lbp084 (substr (cdr (assoc 430 lbp092)) (+ 2 (vl-string-search \"$\" (cdr (assoc 430 lbp092))))))
          (progn
          (if (assoc 420 lbp092)
          (progn
          (setq lbp085 (cdr (assoc 420 lbp092)))
          (setq lbp084 (strcat (itoa (lsh (fix lbp085) -16)) \",\" (itoa (lsh (lsh (fix lbp085) 16) -24)) \",\" (itoa (lsh (lsh (fix lbp085) 24) -24)))))
          (progn
          (if (< lbp083 8)
          (setq lbp084 (nth (1- lbp083) (list \"Rot\" \"Gelb\" \"Grn\" \"Cyan\" \"Blau\" \"Magenta\" \"Wei\")))
          (setq lbp084 (strcat \"Farbe \" (itoa lbp083))))))))))
          (if (= lbp083 256)
          (progn
          (setq lbp084 \"VonLayer\")
          (setq lbp086 (nth (atoi (get_tile \"pl_01\")) lbp060))
          (setq lbp087 (entget (tblobjname \"LAYER\" lbp086)))
          (setq lbp083 (abs (cdr (assoc 62 lbp087))))))
          (if (= lbp083 0)
          (progn
          (setq lbp084 \"VonBlock\")
          (setq lbp083 7)))
          (set_tile \"t_02\" (pbl010 lbp084 33))
          (start_image \"ib_01\")
          (fill_image 0 0 (dimx_tile \"ib_01\") (dimy_tile \"ib_01\") lbp083)
          (end_image)))"
        )
        (action_tile "ib_01" "(setq lbp088 (nth (atoi (get_tile \"pl_01\")) lbp060))
          (setq lbp089 (entget (tblobjname \"LAYER\" lbp088)))
          (if (assoc 430 lbp089)
          (setq lbp091 (assoc 430 lbp089))
          (progn
          (if (assoc 420 lbp089)
          (setq lbp091 (assoc 420 lbp089))
          (setq lbp091 (cons 62 (abs (cdr (assoc 62 lbp089))))))))
          (if (setq lbp092 (acad_truecolordlg (last acm82022grlibozupl_06) T lbp091))
          (progn
          (setq acm82022grlibozupl_06 lbp092)
          (setq lbp083 (abs (cdr (assoc 62 lbp092))))
          (if (and
          (> lbp083 0)
          (< lbp083 256))
          (progn
          (if (assoc 430 lbp092)
          (setq lbp084 (substr (cdr (assoc 430 lbp092)) (+ 2 (vl-string-search \"$\" (cdr (assoc 430 lbp092))))))
          (progn
          (if (assoc 420 lbp092)
          (progn
          (setq lbp085 (cdr (assoc 420 lbp092)))
          (setq lbp084 (strcat (itoa (lsh (fix lbp085) -16)) \",\" (itoa (lsh (lsh (fix lbp085) 16) -24)) \",\" (itoa (lsh (lsh (fix lbp085) 24) -24)))))
          (progn
          (if (< lbp083 8)
          (setq lbp084 (nth (1- lbp083) (list \"Rot\" \"Gelb\" \"Grn\" \"Cyan\" \"Blau\" \"Magenta\" \"Wei\")))
          (setq lbp084 (strcat \"Farbe \" (itoa lbp083))))))))))
          (if (= lbp083 256)
          (progn
          (setq lbp084 \"VonLayer\")
          (setq lbp086 (nth (atoi (get_tile \"pl_01\")) lbp060))
          (setq lbp087 (entget (tblobjname \"LAYER\" lbp086)))
          (setq lbp083 (abs (cdr (assoc 62 lbp087))))))
          (if (= lbp083 0)
          (progn
          (setq lbp084 \"VonBlock\")
          (setq lbp083 7)))
          (set_tile \"t_02\" (pbl010 lbp084 33))
          (start_image $key)
          (fill_image 0 0 (dimx_tile $key) (dimy_tile $key) lbp083)
          (end_image)))"
        )
        (action_tile "tg_01" "(if (> (atoi $value) 0)
          (progn
          (mode_tile \"tg_02\" 1)
          (mode_tile \"b_01\" 1)
          (mode_tile \"ib_01\" 1)
          (mode_tile \"t_02\" 1)
          (mode_tile \"tg_03\" 1)
          (mode_tile \"pl_01\" 1)
          (mode_tile \"tg_04\" 1)
          (mode_tile \"pl_02\" 1))
          (progn
          (mode_tile \"tg_02\" 0)
          (mode_tile \"tg_03\" 0)
          (mode_tile \"tg_04\" 0)
          (if (> (atoi (get_tile \"tg_02\")) 0)
          (progn
          (mode_tile \"b_01\" 0)
          (mode_tile \"ib_01\" 0)
          (mode_tile \"t_02\" 0)))
          (if (> (atoi (get_tile \"tg_03\")) 0)
          (mode_tile \"pl_01\" 0))
          (if (> (atoi (get_tile \"tg_04\")) 0)
          (mode_tile \"pl_02\" 0))))
          (setq acm82022grlibozupl_07 (atoi $value))"
        )
        (action_tile "tg_02" "(if (< (atoi $value) 1)
          (progn
          (mode_tile \"b_01\" 1)
          (mode_tile \"ib_01\" 1)
          (mode_tile \"t_02\" 1))
          (progn
          (mode_tile \"b_01\" 0)
          (mode_tile \"ib_01\" 0)
          (mode_tile \"t_02\" 0)))
          (setq acm82022grlibozupl_08 (atoi $value))"
        )
        (action_tile "tg_03" "(if (< (atoi $value) 1)
          (progn
          (mode_tile \"pl_01\" 1))
          (progn
          (mode_tile \"pl_01\" 0)))
          (setq acm82022grlibozupl_09 (atoi $value))")
          (action_tile "tg_04" "(if (< (atoi $value) 1)
          (progn
          (mode_tile \"pl_02\" 1))
          (progn
          (mode_tile \"pl_02\" 0)))
          (setq acm82022grlibozupl_10 (atoi $value))"
        )
        (action_tile "b_02" "(if (and (< (atoi (get_tile \"tg_01\")) 1) (< (atoi (get_tile \"tg_02\")) 1) (< (atoi (get_tile \"tg_03\")) 1) (< (atoi (get_tile \"tg_04\")) 1))
          (alert \"Bitte whlen Sie mindestens eine zu ndernde Eigenschaft.\")
          (progn
          (setq lbp093 (list (get_tile \"tg_01\") (get_tile \"tg_02\") (get_tile \"tg_03\") (get_tile \"tg_04\") acm82022grlibozupl_06 acm82022grlibozupl_04 (pbl001 acm82022grlibozupl_05) (setq acm82022grlibozupl_03 (get_tile \"tg_05\")) (setq acm82022grlibozupl_02 (get_tile \"rb_02\")) (setq acm82022grlibozupl_01 (get_tile \"pl_00\")))) (pbl019 1 lbp012 lbp013 1) (done_dialog)))"
        )
        (action_tile "b_03" "(setq acm82022grlibozupl_06 lbp071)
          (setq acm82022grlibozupl_04 lbp072)
          (setq acm82022grlibozupl_05 lbp070)
          (setq acm82022grlibozupl_07 lbp079)
          (setq acm82022grlibozupl_08 lbp080)
          (setq acm82022grlibozupl_09 lbp081)
          (setq acm82022grlibozupl_10 lbp082)
          (setq acm82022grlibozupl_01 lbp073)
          (setq acm82022grlibozupl_02 lbp074)
          (setq lbp093 nil)
          (done_dialog)"
        )
      (start_dialog)
      (unload_dialog lbp063)
      lbp093
    )
    (defun pbl012 (lbp014 lbp015 / lbp094 lbp095 lbp096 lbp097)
      (setq lbp094 (strlen lbp014))
      (setq lbp095 1)
        (while (<= lbp095 lbp094)
          (setq lbp096 (substr lbp014 lbp095 1))
            (if (/= lbp096 lbp015)
              (progn
                (setq lbp097 nil)
                (setq lbp095 (1+ lbp095))
              )
            )
            (if (= lbp096 lbp015)
              (progn
                (setq lbp097 lbp095)
                (setq lbp095 (1+ lbp094))
              )
            )
        )
      lbp097
    )
    (defun pbl013 (lbp016 / lbp029)
        (if (= lbp016 0)
          (setq lbp029 "_ByBlock")
          (progn
            (if (= lbp016 256)
              (setq lbp029 "_ByLayer")
              (setq lbp029 (itoa lbp016))
            )
          )
        )
      lbp029
    )
    (defun pbl014 (lbp017 lbp018 / lbp098 lbp099 lbp100 lbp101 lbp102 lbp103 lbp104 lbp105 lbp106 lbp107 lbp108 lbp109)
      (if (= (car lbp018) "0")
        (progn
          (setq lbp098 (cadr lbp018))
          (setq lbp099 (caddr lbp018))
          (setq lbp100 (cadddr lbp018))
          (setq lbp101 (nth 5 lbp018))
          (setq lbp102 (nth 6 lbp018))
            (if (= lbp098 "1")
              (progn
                (setq lbp103 (last (nth 4 lbp018)))
                  (if (= (car lbp103) 62)
                    (progn
                      (setq lbp104 0)
                      (setq lbp105 (pbl013 (cdr lbp103)))
                    )
                  )
                  (if (= (car lbp103) 420)
                    (progn
                      (setq lbp104 1)
                      (setq lbp106 (pbl016 (cdr lbp103)))
                    )
                  )
                  (if (= (car lbp103) 430)
                    (progn
                      (setq lbp104 2)
                      (setq lbp107 (pbl015 (cdr lbp103)))
                      (setq lbp108 (car lbp107))
                      (setq lbp109 (cadr lbp107))
                    )
                  )
              )
            )
            (if
              (and
                (= lbp098 "1")
                (= lbp099 "0")
                (= lbp100 "0")
              )
                (progn
                  (if (= lbp104 0)
                    (command "._chprop" lbp017 "" "_color" lbp105 "")
                  )
                  (if (= lbp104 1)
                    (command "._chprop" lbp017 "" "_color" "_truecolor" lbp106 "")
                  )
                  (if (= lbp104 2)
                    (command "._chprop" lbp017 "" "_color" "_colorbook" lbp108 lbp109 "")
                  )
                )
            )
            (if
              (and
                (= lbp098 "1")
                (= lbp099 "1")
                (= lbp100 "0")
              )
                (progn
                  (if (= lbp104 0)
                    (command "._chprop" lbp017 "" "_color" lbp105 "_layer" lbp101 "")
                  )
                  (if (= lbp104 1)
                    (command "._chprop" lbp017 "" "_color" "_truecolor" lbp106 "_layer" lbp101 "")
                  )
                  (if (= lbp104 2)
                    (command "._chprop" lbp017 "" "_color" "_colorbook" lbp108 lbp109 "_layer" lbp101 "")
                  )
                )
            )
            (if
              (and
                (= lbp098 "1")
                (= lbp099 "0")
                (= lbp100 "1")
              )
                (progn
                  (if (= lbp104 0)
                    (command "._chprop" lbp017 "" "_color" lbp105 "_ltype" lbp102 "")
                  )
                  (if (= lbp104 1)
                    (command "._chprop" lbp017 "" "_color" "_truecolor" lbp106 "_ltype" lbp102 "")
                  )
                  (if (= lbp104 2)
                    (command "._chprop" lbp017 "" "_color" "_colorbook" lbp108 lbp109 "_ltype" lbp102 "")
                  )
                )
            )
            (if
              (and
                (= lbp098 "1")
                (= lbp099 "1")
                (= lbp100 "1")
              )
                (progn
                  (if (= lbp104 0)
                    (command "._chprop" lbp017 "" "_color" lbp105 "_layer" lbp101 "_ltype" lbp102 "")
                  )
                  (if (= lbp104 1)
                    (command "._chprop" lbp017 "" "_color" "_truecolor" lbp106 "_layer" lbp101 "_ltype" lbp102 "")
                  )
                  (if (= lbp104 2)
                    (command "._chprop" lbp017 "" "_color" "_colorbook" lbp108 lbp109 "_layer" lbp101 "_ltype" lbp102 "")
                  )
                )
            )
            (if
              (and
                (= lbp098 "0")
                (= lbp099 "1")
                (= lbp100 "0")
              )
                (command "._chprop" lbp017 "" "_layer" lbp101 "")
            )
            (if
              (and
                (= lbp098 "0")
                (= lbp099 "1")
                (= lbp100 "1")
              )
                (command "._chprop" lbp017 "" "_layer" lbp101 "_ltype" lbp102 "")
            )
            (if
              (and
                (= lbp098 "0")
                (= lbp099 "0")
                (= lbp100 "1")
              )
                (command "._chprop" lbp017 "" "_ltype" lbp102 "")
            )
        )
      )
    )
    (defun pbl015 (lbp019 / lbp110)
      (setq lbp110 (pbl012 lbp019 "\044"))
        (list
          (substr lbp019 1 (1- lbp110))
          (substr lbp019 (1+ lbp110))
        )
    )
    (defun pbl016 (lbp020 / )
      (strcat (itoa (lsh (fix lbp020) -16)) "," (itoa (lsh (lsh (fix lbp020) 16) -24)) "," (itoa (lsh (lsh (fix lbp020) 24) -24)))
    )
    (defun pbl017 (lbp021 / lbp111 lbp112)
      (setq lbp111 (getvar "PEDITACCEPT"))
      (setq lbp112 (getvar "PLINETYPE"))
      (setvar "PLINETYPE" (nth (atoi acm82022grlibozupl_02) (list 2 0)))
      (setvar "PEDITACCEPT" 1)
      (vl-cmdf "._pedit" "_m" lbp021 "" "")
      (setvar "PEDITACCEPT" lbp111)
      (setvar "PLINETYPE" lbp112)
    )
    (defun pbl018 (lbp012 lbp013 / lbp113 lbp114 lbp115 lbp116)
        (if (ssget "_i")
          (sssetfirst nil nil)
        )
      (initget "Einstellungen")
      (setq lbp113 (getkword "\nObjektwahl mit EINGABETASTE starten oder [Einstellungen] <Objektwahl starten>: "))
        (while lbp113
          (setq lbp114 (pbl011 lbp012 lbp013))
          (initget "Einstellungen")
          (setq lbp113 (getkword "\nObjektwahl mit EINGABETASTE starten oder [Einstellungen] <Objektwahl starten>: "))
        )
      (prompt (nth (atoi acm82022grlibozupl_01) (list "\nUmzuwandelnde Linien whlen ... " "\nUmzuwandelnde Bogen whlen ... " "\nUmzuwandelnde Linien und Bogen whlen ... ")))
        (if (not (vl-position acm82022grlibozupl_01 '("0" "1" "2")))
          (setq acm82022grlibozupl_01 "2")
        )
      (setq lbp115 (nth (atoi acm82022grlibozupl_01) (list "LINE" "ARC" "ARC,LINE")))
      (setq lbp116 (ssget "_:L" (list (cons 0 lbp115))))
      lbp116
    )
    (defun pbl019 (lbp022 lbp023 lbp024 lbp025 / )
      (if (not (vl-position acm82022grlibozupl_08 '(0 1)))
        (setq acm82022grlibozupl_08 0)
      )
      (if (not (vl-position acm82022grlibozupl_09 '(0 1)))
        (setq acm82022grlibozupl_09 0)
      )
      (if (not (vl-position acm82022grlibozupl_10 '(0 1)))
        (setq acm82022grlibozupl_10 0)
      )
      (if (not (vl-position acm82022grlibozupl_01 '("0" "1" "2")))
        (setq acm82022grlibozupl_01 "2")
      )
      (if (not (vl-position acm82022grlibozupl_02 '("0" "1")))
        (setq acm82022grlibozupl_02 "0")
      )
      (if (not (vl-position acm82022grlibozupl_07 '(0 1)))
        (setq acm82022grlibozupl_07 1)
      )
      (if (not (vl-position acm82022grlibozupl_03 '("0" "1")))
        (setq acm82022grlibozupl_03 "0")
      )
      (if (not (= (type acm82022grlibozupl_04) 'STR))
        (setq acm82022grlibozupl_04 "0")
      )
      (if (not (pbl007 acm82022grlibozupl_04 lbp023))
        (setq acm82022grlibozupl_04 "0")
      )
      (if (not (= (type acm82022grlibozupl_05) 'STR))
        (setq acm82022grlibozupl_05 "VonLayer")
      )
      (if (not (pbl007 acm82022grlibozupl_05 lbp024))
        (setq acm82022grlibozupl_05 "VonLayer")
      )
      (if (not (= (type acm82022grlibozupl_06) 'LIST))
        (setq acm82022grlibozupl_06 '((62 . 256)))
      )
      (if (not (vl-position acm82022grlibozupl_08 '(0 1)))
        (setq acm82022grlibozupl_08 0)
      )
      (if (not (vl-position acm82022grlibozupl_09 '(0 1)))
        (setq acm82022grlibozupl_09 0)
      )
      (if (not (vl-position acm82022grlibozupl_10 '(0 1)))
        (setq acm82022grlibozupl_10 0)
      )
      (if (= lbp025 1)
        (prompt
          (strcat
            (nth lbp022 (list "\nAktuelle Einstellungen: " "\nNeue Einstellungen: "))
            "Einzubez. O.-Typen = "
            (nth (atoi acm82022grlibozupl_01) (list "Linien" "Bogen" "Linien + Bogen"))
            ", Umwandeln in = "
            (nth (atoi acm82022grlibozupl_02) (list "LW-Polylinien" "2D-Polylinien"))
            ", Eigenschaften = "
            (nth acm82022grlibozupl_07 (list "Neue zuweisen" "Von Quellobjekten"))
            ", Quellobjekte erhalten = "
            (nth (atoi acm82022grlibozupl_03) (list "Nein" "Ja"))
          )
        )
      )
      (list
        (itoa acm82022grlibozupl_07)
        (itoa acm82022grlibozupl_08)
        (itoa acm82022grlibozupl_09)
        (itoa acm82022grlibozupl_10)
        acm82022grlibozupl_06
        acm82022grlibozupl_04
        (pbl001 acm82022grlibozupl_05)
        acm82022grlibozupl_03
        acm82022grlibozupl_02
        acm82022grlibozupl_01
      )
    )
    (defun pbl020 (lbp017 / )
      (vl-cmdf "._copy" lbp017 "" (list 0.0 0.0 0.0) (list 0.0 0.0 0.0))
    )
    (defun pbl021 (lbp026 / lbp117 lbp118)
      (setq lbp117 (ssadd))
        (while (setq lbp118 (entnext lbp026))
          (ssadd lbp118 lbp117)
          (setq lbp026 lbp118)
        )
      lbp117
    )
    (defun pbl022 ( / lbp119 lbp120 lbp114 lbp121 lbp122 lbp123 lbp124 lbp125 lbp126 lbp127 lbp128)
      (setq lbp119 (pbl003))
      (setq lbp120 (pbl004))
      (setq lbp114 (pbl019 0 lbp119 lbp120 1))
        (if (setq lbp121 (pbl018 lbp119 lbp120))
          (progn
            (setq lbp122 (getvar "CMDECHO"))
            (setvar "CMDECHO" 0)
              (if (= acm82022grlibozupl_03 "1")
                (pbl020 lbp121)
              )
            (setq lbp123 (entlast))
            (pbl017 lbp121)
              (if (= acm82022grlibozupl_07 0)
                (progn
                  (setq lbp124 (pbl019 0 lbp119 lbp120 0))
                  (setq lbp125 (pbl021 lbp123))
                    (if (> (sslength lbp125) 0)
                      (progn
                        (pbl014 lbp125 lbp124)
                          (if (= acm82022grlibozupl_03 "1")
                            (progn
                              (setq lbp126 (vlax-ename->vla-object (tblobjname "LAYER" (setq lbp127 (vla-get-Layer (vlax-ename->vla-object (ssname lbp125 0)))))))
                                (if (= (vla-get-Lock lbp126) :vlax-true)
                                  (progn
                                    (setq lbp128 T)
                                    (vla-put-Lock lbp126 :vlax-false)
                                  )
                                )
                              (vl-cmdf "._draworder" lbp125 "" "_front")
                                (if lbp128
                                  (vla-put-Lock lbp126 :vlax-true)
                                )
                            )
                          )
                      )
                    )
                )
              )
            (setvar "CMDECHO" lbp122)
          )
        )
    )
    (defun pbl023 (lbp027 / )
      (if lbp129 (setq *error* lbp129))
      (setq lbp129 nil)
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
        (if lbp122
          (vl-catch-all-apply 'setvar (list "CMDECHO" lbp122))
        )
        (if lbp111
          (vl-catch-all-apply 'setvar (list "PEDITACCEPT" lbp111))
        )
        (if lbp112
          (vl-catch-all-apply 'setvar (list "PLINETYPE" lbp112))
        )
      (setq lbp129 nil lbp122 nil lbp111 nil lbp112 nil)
      (princ)
    )
  (if (pbl002)
    (progn
      (vl-load-com)
      (setq lbp032 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (vla-EndUndoMark lbp032)
      (vla-StartUndoMark lbp032)
      (setq lbp129 *error*)
      (setq *error* pbl023)
      (pbl022)
      (setq *error* lbp129)
      (vla-EndUndoMark lbp032)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-LIBOZUPL (Copyright  2022 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-LIBOZUPL auf.")
